/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.LoadCycleListener;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.BundleViewContentProvider;
import com.aptana.scripting.ui.views.BundleViewLabelProvider;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class BundleView
extends ViewPart {
    private TreeViewer treeViewer;
    private BundleViewContentProvider contentProvider;
    private BundleViewLabelProvider labelProvider;
    private LoadCycleListener loadCycleListener;
    private Job refreshJob;

    private void addListeners() {
        this.listenForScriptChanges();
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.contentProvider = new BundleViewContentProvider();
        this.labelProvider = new BundleViewLabelProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput((Object)BundleManager.getInstance());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IBaseLabelProvider provider;
                String name1 = null;
                String name2 = null;
                if (viewer != null && viewer instanceof ContentViewer && (provider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)provider;
                    name1 = labelProvider.getText(e1);
                    name2 = labelProvider.getText(e2);
                }
                if (name1 == null) {
                    name1 = e1.toString();
                }
                if (name2 == null) {
                    name2 = e2.toString();
                }
                return name1.compareTo(name2);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.hookContextMenu();
        this.addListeners();
    }

    public void dispose() {
        this.getSite().setSelectionProvider(null);
        BundleManager.getInstance().removeLoadCycleListener(this.loadCycleListener);
        super.dispose();
    }

    private void fillContextMenu(IMenuManager manager) {
        BaseNode node;
        Action[] actions;
        TreeSelection treeSelection;
        Object item;
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof TreeSelection && (item = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof BaseNode && (actions = (node = (BaseNode)item).getActions()) != null) {
            Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                manager.add((IAction)action);
                ++n2;
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BundleView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void listenForScriptChanges() {
        this.loadCycleListener = new LoadCycleListener(){

            public void scriptLoaded(File script) {
                BundleView.this.refresh();
            }

            public void scriptReloaded(File script) {
                BundleView.this.refresh();
            }

            public void scriptUnloaded(File script) {
                BundleView.this.refresh();
            }
        };
        BundleManager.getInstance().addLoadCycleListener(this.loadCycleListener);
    }

    public void refresh() {
        if (this.refreshJob != null && this.refreshJob.shouldSchedule()) {
            this.refreshJob.cancel();
        }
        this.refreshJob = new UIJob("Refresh Bundles View"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!BundleView.this.treeViewer.getTree().isDisposed()) {
                    BundleView.this.treeViewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setPriority(20);
        this.refreshJob.schedule();
    }

    public void setFocus() {
    }
}

